# VirtualComPy2R

Консольное приложение для работы с последовательными портами (COM-портами) на Rust.

## Возможности

- Отправка текстовых сообщений
- Отправка HEX данных
- Отправка HEX данных с автоматическим расчетом CRC16
- Отправка предустановленных команд ТАКТ
- Настройка параметров порта (скорость, биты данных, стоп-биты, четность, управление потоком)
- Отображение принимаемых данных в HEX и текстовом формате (если возможно)

## Требования

- Rust 1.50+
- Библиотеки: serialport, crc, crossterm

## Установка
```bash
git clone https://github.com/yourusername/VirtualComPy2R.git
cd VirtualComPy2R
cargo build --release
```

## Запуск через Cargo (на любой платформе):
```bash
cargo run
or
cargo run --release
```
ИЛИ

```powershell
# В PowerShell: 
./target/debug/virtualcompy2r.exe
```

```cmd
# В командной строке:
target\release\virtualcompy2r.exe
```
### В Linux/macOS:
```bash
./target/release/virtualcompy2r
```


## Структура проекта

- `src/main.rs` - основной файл с меню и логикой приложения
- `src/common.rs` - общие функции для работы с портами
- `src/main_takt.rs` - функции для работы с командами ТАКТ

## Лицензия

MIT


