#!/usr/bin/env python3
"""
Скрипт для создания MSI инсталятора с помощью cx_Freeze
"""

import sys
import subprocess
from cx_Freeze import setup, Executable

def check_cx_freeze():
    """Проверяем, установлен ли cx_Freeze"""
    try:
        import cx_Freeze
        return True
    except ImportError:
        return False

def install_cx_freeze():
    """Устанавливаем cx_Freeze"""
    print("Устанавливаем cx_Freeze...")
    subprocess.run([sys.executable, "-m", "pip", "install", "cx_Freeze"], check=True)
    print("cx_Freeze установлен!")

# Настройки для сборки
build_exe_options = {
    "packages": ["numpy", "matplotlib", "collections", "tkinter"],
    "excludes": ["unittest"],
    "include_files": [],
    "optimize": 2
}

# Настройки для MSI
bdist_msi_options = {
    "upgrade_code": "{12345678-1234-1234-1234-123456789012}",
    "add_to_path": False,
    "initial_target_dir": r"[ProgramFilesFolder]\ImpulseSimulator",
    "install_icon": "icon.ico" if __file__.endswith(".py") else None
}

# Исполняемый файл
base = None
if sys.platform == "win32":
    # Используем консольное приложение для интерактивного ввода
    base = None

executables = [
    Executable(
        "app.py",
        base=base,
        target_name="ImpulseSimulator.exe",
        icon="icon.ico" if __file__.endswith(".py") else None,
        shortcut_name="Моделирование попаданий импульса",
        shortcut_dir="DesktopFolder"
    )
]

def create_msi():
    """Создает MSI инсталятор"""
    if not check_cx_freeze():
        try:
            install_cx_freeze()
        except subprocess.CalledProcessError:
            print("❌ Не удалось установить cx_Freeze")
            return
    
    setup(
        name="ImpulseSimulator",
        version="1.0.0",
        description="Программа для моделирования попаданий импульса",
        author="Your Name",
        options={
            "build_exe": build_exe_options,
            "bdist_msi": bdist_msi_options
        },
        executables=executables
    )

if __name__ == "__main__":
    # Если запускается напрямую, создаем MSI
    import os
    os.system(f"{sys.executable} create_msi_installer.py bdist_msi") 