# PowerShell скрипт для сборки инсталятора
# Кодировка UTF-8
[Console]::OutputEncoding = [System.Text.Encoding]::UTF8

Write-Host "================================" -ForegroundColor Cyan
Write-Host "  Сборка инсталятора и портабл" -ForegroundColor Cyan
Write-Host "  Моделирование попаданий импульса" -ForegroundColor Cyan
Write-Host "================================" -ForegroundColor Cyan
Write-Host

# Проверяем виртуальное окружение
if (-not (Test-Path "venv")) {
    Write-Host "❌ Виртуальное окружение не найдено!" -ForegroundColor Red
    Write-Host "Создаем виртуальное окружение..." -ForegroundColor Yellow
    python -m venv venv
}

# Активируем виртуальное окружение
Write-Host "🔄 Активируем виртуальное окружение..." -ForegroundColor Yellow
& ".\venv\Scripts\Activate.ps1"

# Устанавливаем зависимости
Write-Host "📦 Устанавливаем зависимости..." -ForegroundColor Yellow
pip install -r requirements.txt
pip install pyinstaller cx_Freeze

# Создаем исполняемый файл
Write-Host "🏗️ Создаем исполняемый файл..." -ForegroundColor Yellow
python build_installer.py

# Проверяем результат
if (Test-Path "dist\ImpulseSimulator.exe") {
    Write-Host
    Write-Host "✅ ГОТОВО!" -ForegroundColor Green
    Write-Host
    Write-Host "📁 Файлы созданы:" -ForegroundColor Green
    Write-Host "   - dist\ImpulseSimulator.exe (основной исполняемый файл)" -ForegroundColor White
    Write-Host "   - portable\ImpulseSimulator.exe (портабл версия)" -ForegroundColor White
    Write-Host "   - portable\README.txt (инструкция для портабл)" -ForegroundColor White
    Write-Host
    Write-Host "🚀 Для запуска портабл версии:" -ForegroundColor Cyan
    Write-Host "   cd portable" -ForegroundColor White
    Write-Host "   .\ImpulseSimulator.exe" -ForegroundColor White
    Write-Host
    Write-Host "📋 Для создания MSI инсталятора:" -ForegroundColor Cyan
    Write-Host "   python create_msi_installer.py bdist_msi" -ForegroundColor White
    Write-Host
    Write-Host "📋 Для создания Inno Setup инсталятора:" -ForegroundColor Cyan
    Write-Host "   - Установите Inno Setup" -ForegroundColor White
    Write-Host "   - Откройте setup.iss в Inno Setup" -ForegroundColor White
    Write-Host "   - Нажмите 'Compile'" -ForegroundColor White
    Write-Host
    Read-Host "Нажмите Enter для выхода"
} else {
    Write-Host "❌ Ошибка: исполняемый файл не создан!" -ForegroundColor Red
    Read-Host "Нажмите Enter для выхода"
} 