@echo off
chcp 65001 >nul
echo ================================
echo   Сборка инсталятора и портабл
echo   Моделирование попаданий импульса
echo ================================
echo.

:: Проверяем виртуальное окружение
if not exist "venv" (
    echo ❌ Виртуальное окружение не найдено!
    echo Создаем виртуальное окружение...
    python -m venv venv
)

:: Активируем виртуальное окружение
echo 🔄 Активируем виртуальное окружение...
call venv\Scripts\activate.bat

:: Устанавливаем зависимости
echo 📦 Устанавливаем зависимости...
pip install -r requirements.txt
pip install pyinstaller cx_Freeze

:: Создаем исполняемый файл
echo 🏗️ Создаем исполняемый файл...
python build_installer.py

:: Проверяем результат
if exist "dist\ImpulseSimulator.exe" (
    echo.
    echo ✅ ГОТОВО!
    echo.
    echo 📁 Файлы созданы:
    echo    - dist\ImpulseSimulator.exe (основной исполняемый файл)
    echo    - portable\ImpulseSimulator.exe (портабл версия)
    echo    - portable\README.txt (инструкция для портабл)
    echo.
    echo 🚀 Для запуска портабл версии:
    echo    cd portable
    echo    ImpulseSimulator.exe
    echo.
    echo 📋 Для создания MSI инсталятора:
    echo    python create_msi_installer.py bdist_msi
    echo.
    echo 📋 Для создания Inno Setup инсталятора:
    echo    - Установите Inno Setup
    echo    - Откройте setup.iss в Inno Setup
    echo    - Нажмите "Compile"
    echo.
    pause
) else (
    echo ❌ Ошибка: исполняемый файл не создан!
    pause
) 