# Инструкция по запуску программы моделирования попаданий импульса

## 🚀 Быстрый старт (Портабл версия) - РЕКОМЕНДУЕТСЯ

### ✨ Самый простой способ запуска без установки Python:

1. **Скачайте портабл версию** из папки `portable/`
2. **Запустите** `ImpulseSimulator.exe`
3. **Готово!** Программа работает без установки

```bash
# Перейдите в папку с портабл версией
cd portable

# Запустите программу
.\ImpulseSimulator.exe

# Или в тестовом режиме
.\ImpulseSimulator.exe --test
```

**Преимущества портабл версии:**
- ✅ Не требует установки Python
- ✅ Все библиотеки включены
- ✅ Работает на любом Windows 7-11
- ✅ Размер: всего 32 МБ
- ✅ Создает графики автоматически

---

## 🔧 Установка из исходного кода (для разработчиков)

### Требования
- Python 3.13+
- pip (установщик пакетов Python)

---

## Установка и запуск на **MacOS**

### 1. Перейдите в папку проекта:
```bash
cd /Users/olgazaharova/Project/ProjectPython/Artefact
```

### 2. Создайте и активируйте виртуальное окружение:
```bash
python3 -m venv venv
source venv/bin/activate
```

### 3. Установите зависимости:
```bash
pip install -r requirements.txt
```

### 4. Запустите программу:
```bash
python3 app.py
```

---

## Установка и запуск на **Windows (cmd)**

### 1. Перейдите в папку проекта:
```bat
cd C:\Project\ProjectPython\Artefact
```

### 2. Создайте и активируйте виртуальное окружение:
```bat
python -m venv venv
venv\Scripts\activate
```

### 3. Установите зависимости:
```bat
pip install -r requirements.txt
```

### 4. Запустите программу:
```bat
python app.py
```

---

## Установка и запуск на **Windows (PowerShell)**

### 1. Перейдите в папку проекта:
```powershell
cd C:\Project\ProjectPython\Artefact
```

### 2. Создайте виртуальное окружение:
```powershell
python -m venv venv
```

### 3. Активируйте виртуальное окружение:
```powershell
.\venv\Scripts\Activate.ps1
```

### 4. Установите зависимости:
```powershell
pip install -r requirements.txt
```

### 5. Запустите программу:
```powershell
python app.py
```

---

## 🔨 Создание собственного инсталятора

### Автоматическая сборка портабл версии:

**Для Windows Command Prompt:**
```bat
build.bat
```

**Для PowerShell:**
```powershell
.\build.ps1
```

**Ручная сборка:**
```powershell
python build_installer.py
```

### Создание MSI инсталятора:
```powershell
python create_msi_installer.py bdist_msi
```

### Создание профессионального инсталятора:
1. Установите [Inno Setup](https://jrsoftware.org/isinfo.php)
2. Откройте файл `setup.iss`
3. Нажмите **Build** → **Compile**

---

## 📖 Как пользоваться программой

### Основные возможности:
1. **Интерактивный ввод данных** - программа запросит времена стробов
2. **Автоматические расчеты** - симуляция с 100,000 образцов
3. **Визуализация результатов** - создание графика (result.png)
4. **Подробная статистика** - вероятности в процентах

### Пошаговая инструкция:
1. После запуска программа предложит ввести времена появления стробов в периоде (например: 0, 40, 80, 160, 240). Вводите значения по одному, нажимая Enter после каждого.
2. Чтобы завершить ввод, просто нажмите Enter на пустой строке.
3. Программа рассчитает вероятности попаданий импульса и выведет результат на экран, а также создаст график распределения.
4. График автоматически сохранится как `result.png` в папке с программой.

### 🧪 Тестовый режим:
Для быстрой проверки работоспособности:
```bash
.\ImpulseSimulator.exe --test
```
Использует предустановленные данные: [0, 40, 80, 160, 240]

---

---

## 💡 Примеры использования

### **Пример ввода данных:**
```
============================================================
   МОДЕЛИРОВАНИЕ ПОПАДАНИЙ ИМПУЛЬСА
============================================================

Введите времена появления стробов в периоде (по возрастанию, через Enter).
Для завершения введите пустую строку.
Время 1-го строба: 0
✓ Добавлено время: 0.0
Время 2-го строба: 40
✓ Добавлено время: 40.0
Время 3-го строба: 80
✓ Добавлено время: 80.0
Время 4-го строба: 160
✓ Добавлено время: 160.0
Время 5-го строба: 240
✓ Добавлено время: 240.0
Время 6-го строба: 

📋 Введенные времена стробов: [0.0, 40.0, 80.0, 160.0, 240.0]
🔄 Запуск симуляции...
📊 График сохранен как result.png
📁 Размер файла: 28966 байт

========================================
         РЕЗУЛЬТАТЫ
========================================
1 попаданий: 0.1321 (13.21%)
3+ попаданий: 0.5663 (56.63%)
2 попаданий: 0.3016 (30.16%)

✅ Симуляция завершена успешно!
```

### **Результаты:**
- **result.png** - график распределения вероятностей
- **Консольный вывод** - подробная статистика в процентах
- **Файловая информация** - размер созданного графика

---

## 🛠️ Устранение неполадок

### Портабл версия не запускается:
1. **Антивирус**: Добавьте папку в исключения антивируса
2. **Права доступа**: Запустите от имени администратора
3. **Целостность**: Перескачайте файл, если поврежден

### График не создается:
- Это не критично - расчеты будут выполнены
- Проверьте права на запись в папку
- Убедитесь, что папка не защищена от записи

### Проблемы с Python версией:
```bash
# Проверьте версию Python
python --version

# Переустановите зависимости
pip install --upgrade numpy matplotlib

# Пересоберите портабл версию
python build_installer.py
```

---

## 📁 Структура проекта

```
Artefact/
├── portable/                     # 🎯 ГОТОВАЯ ПОРТАБЛ ВЕРСИЯ
│   ├── ImpulseSimulator.exe     # Основная программа (32 МБ)
│   ├── README.txt               # Инструкция для пользователей  
│   └── result.png               # График (создается при запуске)
├── dist/                        # Сборочные файлы PyInstaller
├── build/                       # Временные файлы сборки
├── venv/                        # Виртуальное окружение Python
├── app.py                       # Основной исходный код
├── requirements.txt             # Зависимости Python
├── build.bat / build.ps1        # Скрипты автосборки
├── INSTALL_GUIDE.md             # Подробная документация
└── SUMMARY.md                   # Итоговое резюме
```

---

## 🎯 Для пользователей vs разработчиков

### 👥 **Обычные пользователи (РЕКОМЕНДУЕТСЯ):**
- Используйте **портабл версию** из папки `portable/`
- Просто запустите `ImpulseSimulator.exe`
- Никаких установок не требуется

### 👨‍💻 **Разработчики:**
- Клонируйте репозиторий
- Следуйте инструкциям по установке Python
- Используйте `build.bat` для пересборки

---

## 📞 Поддержка

**Системные требования:**
- **ОС**: Windows 7/8/10/11 (64-bit)
- **ОЗУ**: Минимум 512 МБ
- **Место на диске**: 50 МБ

**Если нужна помощь:**
1. Проверьте раздел "Устранение неполадок"
2. Убедитесь в соответствии системным требованиям
3. Попробуйте тестовый режим: `ImpulseSimulator.exe --test` 