# Руководство по созданию инсталятора и портабл версии

## Обзор

Этот проект предоставляет несколько способов создания дистрибутивов для приложения "Моделирование попаданий импульса":

1. **Портабл версия** - единый .exe файл, не требующий установки
2. **MSI инсталятор** - профессиональный инсталятор Windows
3. **Inno Setup инсталятор** - продвинутый инсталятор с кастомизацией

---

## 🚀 Быстрый старт

### Автоматическая сборка (рекомендуется)

**Для Windows Command Prompt:**
```bat
build.bat
```

**Для PowerShell:**
```powershell
.\build.ps1
```

Эти скрипты автоматически:
- Создают виртуальное окружение (если нужно)
- Устанавливают все зависимости
- Собирают исполняемый файл
- Создают портабл пакет

---

## 📋 Подробные инструкции

### 1. Подготовка окружения

```powershell
# 1. Активируем виртуальное окружение
venv\Scripts\activate

# 2. Устанавливаем зависимости для сборки
pip install pyinstaller cx_Freeze

# 3. Устанавливаем основные зависимости
pip install -r requirements.txt
```

### 2. Создание портабл версии

```powershell
# Запускаем скрипт сборки
python build_installer.py
```

**Результат:**
- `dist/ImpulseSimulator.exe` - основной исполняемый файл
- `portable/ImpulseSimulator.exe` - портабл версия
- `portable/README.txt` - инструкция для пользователей

### 3. Создание MSI инсталятора

```powershell
python create_msi_installer.py bdist_msi
```

**Результат:**
- `dist/ImpulseSimulator-1.0.0-win32.msi` - MSI инсталятор

### 4. Создание Inno Setup инсталятора

1. Скачайте и установите [Inno Setup](https://jrsoftware.org/isinfo.php)
2. Откройте файл `setup.iss` в Inno Setup
3. Нажмите **Build** > **Compile**

**Результат:**
- `installer_output/ImpulseSimulator_Setup.exe` - профессиональный инсталятор

---

## 🔧 Настройка

### Добавление иконки

1. Создайте файл `icon.ico` в корне проекта
2. Перезапустите сборку

### Изменение настроек

**PyInstaller (build_installer.py):**
- `--name` - имя исполняемого файла
- `--onefile` - создать один файл
- `--console` - показывать консоль

**cx_Freeze (create_msi_installer.py):**
- `build_exe_options` - настройки сборки
- `bdist_msi_options` - настройки MSI

**Inno Setup (setup.iss):**
- `AppName` - название приложения
- `AppVersion` - версия
- `DefaultDirName` - папка установки по умолчанию

---

## 📁 Структура файлов после сборки

```
Artefact/
├── dist/                          # Основные исполняемые файлы
│   ├── ImpulseSimulator.exe      # Основной exe
│   └── ImpulseSimulator-1.0.0.msi # MSI инсталятор
├── portable/                      # Портабл версия
│   ├── ImpulseSimulator.exe      # Портабл exe
│   └── README.txt                # Инструкция
├── installer_output/              # Inno Setup вывод
│   └── ImpulseSimulator_Setup.exe # Inno Setup инсталятор
├── build/                        # Временные файлы сборки
└── *.spec                        # Спецификации PyInstaller
```

---

## 🐛 Устранение неполадок

### Ошибка "module not found"
```powershell
pip install --upgrade pyinstaller
pip install --upgrade numpy matplotlib
```

### Проблемы с matplotlib
```powershell
# Переустановите matplotlib
pip uninstall matplotlib
pip install matplotlib
```

### Большой размер exe файла
В `build_installer.py` добавьте:
```python
"--exclude-module", "tkinter",
"--exclude-module", "unittest",
```

### Антивирус блокирует файл
- Добавьте папку проекта в исключения антивируса
- Используйте опцию `--noupx` в PyInstaller

---

## 🎯 Тестирование

### Тест портабл версии
```powershell
cd portable
.\ImpulseSimulator.exe
```

### Тест MSI инсталятора
1. Запустите MSI файл
2. Следуйте инструкциям установки
3. Проверьте работу из меню Пуск

---

## 📞 Поддержка

Если возникли проблемы:

1. Убедитесь, что все зависимости установлены
2. Проверьте, что виртуальное окружение активно
3. Попробуйте пересоздать виртуальное окружение
4. Проверьте версию Python (требуется 3.13+)

**Команды диагностики:**
```powershell
python --version
pip list
where python
``` 