# Описание алгоритма моделирования попаданий импульса (метод Монте-Карло)

## Основная идея

Программа не вычисляет вероятности аналитически, а оценивает их с помощью **метода Монте-Карло** — то есть, многократно имитирует случайное появление импульса и подсчитывает, сколько раз он перекрывает 0, 1, 2, 3 и более стробов. Итоговые вероятности определяются как доля соответствующих случаев среди всех экспериментов.

---

## Почему используется моделирование?

Когда количество стробов в периоде увеличивается, а их расположение становится произвольным, аналитически вычислить вероятности становится очень сложно: интервалы перекрытия могут пересекаться, а формулы усложняются. В таких случаях проще и надёжнее использовать численное моделирование (имитацию экспериментов).

**Преимущества метода Монте-Карло:**
- Универсальность: работает для любой конфигурации стробов и импульса.
- Простота реализации.
- Возможность получить точную оценку вероятностей при большом числе экспериментов.

---

## Как работает моделирование в программе?

1. **Ввод времён стробов** — пользователь задаёт позиции стробов в одном периоде.
2. **Определение длины периода** — по максимальному значению среди введённых времён.
3. **Генерация позиций стробов** — строятся позиции для двух периодов подряд, чтобы учесть перекрытие импульсом границы периода.
4. **Многократное моделирование:**
    - 100 000 раз случайно выбирается момент старта импульса в пределах одного периода.
    - Для каждого старта считается, сколько стробов попало в интервал импульса.
5. **Подсчёт вероятностей:**
    - Для каждого количества попаданий (0, 1, 2, 3+) считается доля соответствующих случаев.
6. **Визуализация и вывод:**
    - Результаты выводятся в консоль и строится гистограмма.

---

## Схема работы алгоритма

```mermaid
graph TD
    A[Ввод времён стробов] --> B[Определение длины периода]
    B --> C[Генерация позиций стробов для двух периодов]
    C --> D[Генерация случайных стартов импульса]
    D --> E[Подсчёт числа попаданий для каждого старта]
    E --> F[Группировка по количеству попаданий]
    F --> G[Расчёт вероятностей]
    G --> H[Вывод и визуализация]
```

---

## Псевдокод моделирования (Монте-Карло)

```
1. Ввести stroby_times (позиции стробов в периоде)
2. period_length = max(stroby_times)
3. stroby_positions = stroby_times + (stroby_times + period_length)
4. Для i = 1 до N (N — число экспериментов):
    4.1. Случайно выбрать t_start ∈ [0, period_length)
    4.2. hits = число стробов, попавших в [t_start, t_start + impulse_length)
    4.3. Сохранить hits
5. Для каждого k = 0, 1, 2, 3+:
    5.1. Вероятность = (число экспериментов с hits = k) / N
6. Вывести вероятности, построить график
```

---

## Пример для трёх стробов

Пусть период T = 100, строб в t1 = 0, t2 = 30, t3 = 70, длина импульса L = 40.

- Импульс перекроет только 1-й строб, если t_start ∈ [0, 30) (не дотянется до второго).
- Только 2-й — если t_start ∈ [30, 60) (не дотянется до третьего).
- Только 3-й — если t_start ∈ [70, 100).
- Два строба (1-й и 2-й) — если t_start ∈ [max(0, 30-L), 0) ∪ [30, 30+L-10) и т.д.
- Три строба — если t_start ∈ [30, 30+L) ∩ [70-L, 70).

Видно, что интервалы могут пересекаться и быть сложными, поэтому моделирование даёт универсальный способ получить вероятности для любой конфигурации.

---

## Теоретический расчёт вероятностей (для простых случаев)

Если импульс стартует равновероятно в пределах одного периода длины `T`, а времена появления стробов в периоде заданы как `t_1, t_2, ..., t_n`, то вероятность того, что импульс перекроет ровно `k` стробов, равна:

- Для каждого возможного набора из `k` стробов определяем множество стартовых позиций импульса, при которых он перекроет именно эти строб(ы) и не перекроет другие.
- Длина этого множества (интервала или объединения интервалов) делится на длину периода `T` — это и есть вероятность.

**Пример для одного строба:**

Пусть период T = 100, в нём один строб в точке t = 0, длина импульса L = 20.
- Импульс перекроет строб, если его старт t_start ∈ [0 - L, 0) = [-20, 0), но так как стартуем только в пределах [0, 100), это [0, 20).
- Длина этого интервала — 20.
- Вероятность попадания: 20 / 100 = 0.2

**Пример для двух стробов:**

Пусть период T = 100, строб в t1 = 0 и t2 = 60, L = 50.
- Импульс перекроет только первый строб, если t_start ∈ [0, 10) (тогда он не дотянется до второго).
- Только второй — если t_start ∈ [60, 100).
- Оба — если t_start ∈ [10, 60).
- Вероятности:
    - Только 1-й: (10-0)/100 = 0.1
    - Только 2-й: (100-60)/100 = 0.4
    - Оба: (60-10)/100 = 0.5

**В общем случае**
- Для каждого набора стробов ищется пересечение интервалов, в которых импульс перекрывает только их.
- Для сложных случаев аналитика затруднительна, поэтому применяется моделирование методом Монте-Карло.

---

## Особенности
- Импульс может перекрывать строб-события из двух соседних периодов.
- Ось времени считается бесконечной, но моделирование проводится в пределах одного периода с учётом двух периодов для корректного учёта перекрытий.
- Программа универсальна: пользователь может задать любое количество и расположение стробов в периоде. 